#include <stdio.h>

extern _rax,_rdx;
extern _carryf;

char *dp;
unsigned dseg;

use_and_exit()
{
  puts("\n");
  puts("use: ccd_cpy a[or b] c\n");
  puts("     ccd_cpy c a[or b]\n");
  exit(0);
}

main(argc,argv)
int argc;
char **argv;
{
 FILE *fpo;
 char fn[32],ch;
 int  wr_ccd;

 if (argc!=3) {
  use_and_exit();
 }
 strcpy(fn,"ccd.bin");

 if (*argv[1]=='c') {
  wr_ccd=1;
  if (*argv[2]=='a') _rdx=0x0101;
  else if (*argv[2]=='b') _rdx=0x0202;
  else use_and_exit();
  if ( (fpo=fopen(fn,"r"))==0 ) {
   puts("FILE open-error !");
   exit(0);
  }
 } else {
  wr_ccd=0;
  if (*argv[2]!='c') use_and_exit();
  if (*argv[1]=='a') _rdx=0x0101;
  else if (*argv[1]=='b') _rdx=0x0202;
  else use_and_exit();
  if ( (fpo=fopen(fn,"w"))==0 ) {
   puts("FILE open-error !");
   exit(0);
  }

 _rax=0x2401;
 _doint(0x61);

 if (_carryf) {
  puts("CCD open-error !");
  fclose(fpo);
  exit(0);
 }

 if (wr_ccd) {
  dseg=0xc000;
  dp=0;
  puts("Write CCD-Block 1 ");
  while (1) {
   ch=fgetc(fpo);
   _poke(ch,dp++,dseg);
   if ( dp==0 ) break;
  }
  dseg=0xd000;
  dp=0;
  puts("\nWrite CCD-Block 2 ");
  while (1) {
   ch=fgetc(fpo);
   _poke(ch,dp++,dseg);
   if ( dp==0 ) break;
  }
 } else {
  dseg=0xc000;
  dp=0;
  puts("Read CCD-Block 1 ");
  while (1) {
   fputc(_peek(dp++,dseg),fpo);
   if ( dp==0 ) break;
  }
  dseg=0xd000;
  dp=0;
  puts("\nRead CCD-Block 2 ");
  while (1) {
   fputc(_peek(dp++,dseg),fpo);
   if ( dp==0 ) break;
  }
 }
 puts("\nok");
 fclose(fpo);
 _rax=0x2401; _rdx=0x0000;
 _doint(0x61);
 puts(" .. bye .. bye ..");
 exit(0);
}
