#include <stdio.h>

extern _rax,_rdx;
extern _carryf;

char *dp;
int pd;
unsigned dseg=0xc000;
FILE *fpi;

use_and_exit()
{
 puts("use: flash_ld file a[or b]\n");
 exit(0);
}

main(argc,argv)
int argc;
char **argv;
{
 char fn[32];
 int i,j;

 if (argc!=3) {
  use_and_exit();
 }

 strcpy(fn,argv[1]);
 if ( (fpi=fopen(fn,"r"))  ==0 ) {
  puts("Datei open-error !");
  exit(0);
 }

 if (*argv[2]=='a') _rdx=0x0101;
 else if (*argv[2]=='b') _rdx=0x0202;
 else use_and_exit();
 _rax=0x2401;
 _doint(0x61);

 if (_carryf) {
  puts("\nINT61 - Error !\n");
  exit(0);
 }

 puts("Erasing Am29F010 !\n");
 erase(); dp=0; pd=0xff;

 if (!data_poll()) {
  fclose(fpi);
  card_off();
  puts("Erasing ERROR !!!!\n");
  exit(1);
 }  

 puts("\nWriting Segment:C !\n");
 dseg=0xc000; dp=0;

 if (!write_segment()) {
  puts(" Seg:C !\n");
  exit(1);
 }  

 puts("\nWriting Segment:D !\n");
 dseg=0xd000; dp=0;

 if (!write_segment()) {
  puts(" Seg:D !\n");
  exit(1);
 }  

 puts("\nWrite FLASH ok !\n");
 fclose(fpi);
 card_off();
 puts("\n .. bye .. bye ..\n");
 exit(0);
}

write_segment()
{
 int wr_ok=1,k=0;

 while (1) {
  pd=fgetc(fpi);
  if (pd==-1) {
   puts("File-Read-Error !\n");
   wr_ok=0;
   break;
  }
  prog();
  if (!data_poll()) {
   puts("Byte-Write-Error !\n");
   wr_ok=0;
   break;
  }
  dp++;
  if (k++==1023) {
   k=0;
   puts(":+"); put4h(dp); puts("+:");
  }
  if ( dp==0 ) break;
 }
 if (wr_ok) return 1;

 fclose(fpi);
 card_off();
 puts("Address: ");
 put4h(dp);
 return 0;
}

data_poll()
{
 int poll_ok=0;
 char fdat,sd7;

 sd7=pd&0x80;
 while (1) {
  fdat=_peek(dp,dseg);
  if ((fdat&0x80)==sd7) {
   poll_ok=1;
   break;
  }
  if (fdat&0x20) break;
 }
 if (!poll_ok) {
  fdat=_peek(dp,dseg);
  if ((fdat&0x80)==sd7) poll_ok=1;
 }
 if (!poll_ok) return 0;
 if (pd==_peek(dp,dseg)) return 1;
 return 0;
}

card_off()
{
 _rax=0x2401; _rdx=0x0000;
 _doint(0x61);
}

erase()
{
#asm
 push ds
 push ax

 mov ax,0c000h
 push ax
 pop ds

 cli
 mov byte[5555h],0aah
 mov byte[2aaah],055h
 mov byte[5555h],080h
 mov byte[5555h],0aah
 mov byte[2aaah],055h
 mov byte[5555h],010h
 sti

 pop ax
 pop ds
#
}

prog()
{
#asm
 push ds
 push ax
 push bx

 mov bx,word dp_
 mov al,byte pd_
 push ax
 mov ax,word dseg_
 push ax
 pop ds
 pop ax

 cli
 mov byte[5555h],0aah
 mov byte[2aaah],055h
 mov byte[5555h],0a0h
 mov byte ds:[bx],al
 sti

 pop bx
 pop ax
 pop ds
#
}

put4h(i)
int i;
{
 put2h(i>>8);
 put2h(i);
}

put2h(i)
int i;
{
 put1h(i>>4);
 put1h(i);
}

put1h(i)
int i;
{
 if ((i&0x0f)>9)
  putchar((i&0x0f)+0x37);
 else
  putchar((i&0x0f)+0x30);
}
