;======================================================================
; Lebenswichtige Bios-Routinen V1.0 15.03.91
; 1991 Ralf Amandi

; Das Kopieren und Benutzen fr private Anwendungen ist ohne
; Einschrnkungen erlaubt.

; Kontaktadresse:
; Ralf Amandi
; 02403/26689 (Anrufbeantworter)
; Konto: 391 501 00 KrSp Eschweiler
; Benutzter Assembler: TASM
; ======================================================================}

		.model	tpascal
		.data
;in SaveIntr definiert
EXTRN		PushRegProc:Proc
EXTRN		PushRegFunc:Proc
EXTRN		PushRegProcBP:Proc
EXTRN		PushRegFuncBP:Proc
EXTRN		PopRegProc :Proc
EXTRN		PopRegFunc :Proc
;-- Vorbesetzung durch Start --
EXTRN		DefMode:Byte
EXTRN		ScrMaxX:Byte
EXTRN		ScrActPage:Byte
EXTRN		AnzCom	:Byte
EXTRN		AnzLPT	:Byte
EXTRN		IstColor:Byte
EXTRN		PC_Config:Word
EXTRN		DosVerHi:Byte;
EXTRN		DosVerLo:Byte;
;-- Als Konstanten im Pascal Prg definiert --
EXTRN		ScrMaxY:Byte
EXTRN		ScrTxtCol:Byte;
EXTRN		ScrBckCol:Byte;

EXTRN		ActWindow
ScrWdXo		equ 	byte ptr ActWindow
ScrWdYo		equ 	byte ptr ActWindow+1
ScrWdXu		equ 	byte ptr ActWindow+2
ScrWdYu		equ 	byte ptr ActWindow+3
TxtX		equ	byte ptr ActWindow+4
TxtY		equ	byte ptr ActWindow+5

EXTRN		ScrOrgX	:Byte;
EXTRN		ScrOrgY	:Byte;
EXTRN		SerStat	:Byte;
EXTRN		ModStat	:Byte;

		.code
public		Start

public		SetTextColor	;(Col:Byte);
public		GetTextColor	;:Byte;
public		SetBackColor	;(Col:Byte);
public		GetBackColor	;:Byte;

public		SetVMode	;(Mode:Byte);
public		GetVMode	;Byte;

public		DefCur		;(Start,End:Byte)
public		Window		;(xo,yu,xu,yu)
public		Gotoxy		;(x,y:Byte)
public	        WhereX		;:Byte
public	        WhereY		;:Byte
public		SelScrPage	;(Seite:Byte);
public		ScrollUp	;(AnzLines)
public		ScrollDwn	;(AnzLines)
public		ClrScr		;benutz ScrollUp
public		KeyPressed	;Boolean;
public		ReadKey		;CHAR
public		KeyStat		;Byte;

public		GetKB		;Word
public		GetPCStatus	;Word
public		ScrGetChar	;(x,y):Word
public		BWrite		;(s:String)
public		BWriteLN	;(s:String)

;Schnittstelle
public		SerIni
public		SerSendChar
public		SerEmpfChar
public		SerGetStat

Start		proc	far
		call    PushRegProcBP
		mov	ah,0Fh
		int	10h
		mov	DefMode,al
		mov	ScrMaxX,ah
		dec	ah
		mov	ScrWdxu,ah
		mov	ScrActPage,bh
		mov	ah,03h
		int	010h
		mov	TxtX,dl
		mov	TxtY,dh
		int	011h
		mov	PC_Config,ax
		add	al,16
		mov	cl,6
		shr	ax,cl;Color ? -> Carry
		sbb	bl,bl;Carry Set->FF Clear->00 (guter Assembler-Trick)
		mov	IstColor,bl
		mov	cl,3
		shr	al,cl
		and	al,7
		mov	AnzCom,al
		mov	AnzLpt,ah
		mov	ah,030h
		int	021h
		mov	DosVerHi,al
		mov	DosVerLo,ah
		call    PopRegProc
		retf
		endp

GetTextColor	proc	far
		mov	al,ScrTxtCol
		xor	ah,ah
		endp

SetTextColor	proc	far
		arg	Col:Byte
		call    PushRegProc
		mov	al,Col
		mov	ScrTxtCol,al
		call    PopRegProc
		retf	2
		endp

GetBackColor	proc	far
		mov	al,ScrBckCol
		xor	ah,ah
		endp

SetBackColor	proc	far
		arg	Col:Byte
		call    PushRegProc
		mov	bl,Col
		mov	ScrBckCol,bl
		xor	bh,bh
		mov	ah,0Bh
		int	010h
		call    PopRegProc
		retf	2
		endp


SetVMode	proc	far
		arg	vmode:Byte
		call    PushRegProc
		mov	al,VMode
		xor	ah,ah
		int	010h
		mov	TxtX,0
		mov	TxtY,0
		call    PopRegProc
		retf	2
		endp

GetVMode	proc	far
		call    PushRegFuncBP
		mov	ah,0Fh
		int	10h
		xor	ah,ah
		call    PopRegFunc
		retf
		endp

DefCur		proc	far
		arg	CStart:Byte,CEnd:Byte
		call    PushRegProc
		mov	ch,CStart
		mov	cl,CEnd
		mov	ah,01h
		int	010h
		call    PopRegProc
		retf	4
		endp

Wtest		proc	near
		cmp	al,ah
		jc	WTest_Ok
		mov	al,ah
Wtest_Ok:	dec	al
		add	al,bl
		ret
		endp

Window		proc	far
		arg	xo:Byte,yo:Byte,xu:Byte,yu:Byte
		call    PushRegProc
		mov	ah,ScrMaxX;grenze WTest
		mov	bl,ScrOrgX;Ursprung WTest
		mov	al,xo
		call	Wtest
		mov	ScrWdxo,al
		mov	TxtX,al
		mov	dl,al
		mov	al,xu
		call	Wtest
		mov	ScrWdXu,al
		mov	ah,ScrMaxY;Grenze WTest
		mov	bl,ScrOrgY;Ursprung WTest
		mov	al,yo
		call	Wtest
		mov	ScrWdyo,al
		mov	TxtY,al
		mov	dh,al
		mov	al,yu
		call	Wtest
		mov	ScrWdYu,al
		mov	bh,ScrActPage
		mov	ah,02h
		int	010h;Cursor setzen
		call    PopRegProc
		retf	8
		endp

GotoXY_DO	proc	near
		dec	dh
		dec	dl
		add	dl,ScrWdxo
		add	dh,ScrWdyo
		cmp	dh,ScrWdYu
		jz	Got_Ok1
		jc	Got_Ok1
		mov	dh,ScrWdYu
Got_Ok1:	cmp	dl,ScrWdXu
		jz	Got_Ok2
		jc	Got_Ok2
		mov	dh,ScrWdXu
Got_Ok2:	mov	bh,ScrActPage
		mov	TxtX,dl
		mov	TxtY,dh
		mov	ah,02h
		int	010h
		ret
		endp

GotoXY		proc	far
		arg	x:Byte,y:Byte
		call    PushRegProc
		mov	dh,y
		mov	dl,x
		call	GotoXY_DO
		call    PopRegProc
		retf	4
		endp

WhereX		proc	far
		xor	ah,ah
		mov	al,TxtX
		sub	al,ScrWdXo
		inc	al
		retf
		endp

WhereY		proc	far
		xor	ah,ah
		mov	al,TxtY
		sub	al,ScrWdYo
		inc	al
		retf
		endp

SelScrPage	proc	far
		arg	Seite:Byte
		call    PushRegProc
		mov	al,Seite
		mov	ScrActPage,al
		mov	ah,05h
		int	010h
		call    PopRegProc
		retf	2
		endp

ScrollUp	proc	far
		arg     Anz:Byte
		call    PushRegProc
		mov	al,Anz
		mov	cl,ScrWdXo
		mov	ch,ScrWdYo
		mov	dl,ScrWdXu
		mov	dh,ScrWdYu
		mov	bh,ScrTxtCol
		mov	ah,6h
		int	010h
		call    PopRegProc
		retf	2
		endp

ScrollDwn	proc	far
		arg     Anz:Byte
		call    PushRegProc
		mov	al,Anz
		mov	cl,ScrWdXo
		mov	ch,ScrWdYo
		mov	dl,ScrWdXu
		mov	dh,ScrWdYu
		mov	bh,ScrTxtCol
		mov	ah,7h
		int	010h
		call    PopRegProc
		retf	2
		endp

ClrScr		proc	far
		call	pushregProcBP
		xor	ax,ax
		push	ax
		call	ScrollUp
		mov	dx,0101h
		call	GotoXY_DO
		call	popregProc
		retf
		endp


KeyPressed	proc	far
		call    PushRegFuncBP
		xor	ax,ax
		push	ax
		mov	ah,01h
		int	016h
		pop	ax
		jz	KeyPr
		mov	ax,0FFFFh
KeyPr:	        ;pop	di
		;pop	si
		;pop	ds
		;pop	es
		;pop	cx
		;pop	bx
		;pop	bp
		call    PopRegFunc
		retf
		endp

KeyBuff		dw	0FFFFh

ReadKey		proc	far
		call    PushRegFuncBP
		test	byte ptr KeyBuff,255
		jnz	Ok_Read
		mov	al,byte ptr KeyBuff+1
		not	KeyBuff
		jmp	short	End_Read
Ok_Read:	mov	ah,0
		int	016h
		mov	KeyBuff,ax
End_Read:	xor	ah,ah
		call    PopRegFunc
		retf
		endp

KeyStat		proc	far
		call    PushRegFuncBP
		mov	ah,02
		int	016h
		xor     ah,ah
		call    PopRegFunc
		retf
		endp

GetKB		proc	far
		int	12h
		retf
		endp

ScrGetChar	proc	far
		arg	x:Byte,y:Byte
		call    PushRegFunc
		mov	dh,y
		mov	dl,x
		call	GotoXY_DO
		mov	bh,ScrActPage
		mov	ah,08h
		int	010h
		call    PopRegFunc
		retf	4
		endp

Wri_NxtLin	proc	near
		inc	TxtY
		mov	dl,TxtY
		cmp	dl,ScrWdYu
		jz	WriNX_End
		jc	WriNX_End
		push	ax
		mov	dx,1
		push	dx
		call	ScrollUp
		pop	ax
		dec	TxtY
WriNX_End:	ret
		endp

WritChar	proc	near
		push	si
		push	ds
		push	cx
		mov	cx,@Data
		mov	ds,cx
		cmp	al,13
		jnz	Wri_NX1
		mov	dl,ScrWdXo
		mov	TxtX,dl
		jmp	short	Wri_End
Wri_NX1:	cmp	al,10
		jnz	Wri_NX2
		call	Wri_NxtLin
		jmp	short	Wri_End
Wri_NX2:	mov	dl,TxtX
		cmp	dl,ScrWdXu
		jz	WriGo
		jc	WriGo
		mov	dl,ScrWdXo
		mov	TxtX,dl
		Call	Wri_NxtLin
WriGo:		mov	dl,TxtX
		mov	dh,TxtY
		mov	bh,ScrActPage
		push	ax
		push	bp
		mov	ah,02h
		int	010h
		pop	bp
		pop	ax
		mov	ah,09h
		mov	bh,ScrActPage
		mov	cx,1
		mov	bl,ScrTxtCol
		int	010h
		inc	TxtX
Wri_End:	pop	cx
		pop	ds
		pop	si
		ret
		endp

BWrite		proc	far
		arg	strg:dword
		call	PushRegProc
		lds	si,strg
		xor	ch,ch
		lodsb
		mov	cl,al;String-lnge
		jcxz	BWr_End
BWr_Loop:	lodsb
		call	WritChar
		loop	BWr_Loop
BWr_End:	call	PopRegProc
		retf	4
		endp

BWriteLN	proc	far
		arg	strg:dword
		call	PushRegProc
		lds	si,strg
		xor	ch,ch
		lodsb
		mov	cl,al;String-lnge
		jcxz	BWrLN_End
BWrLN_Loop:	lodsb
		call	WritChar
		loop	BWrLN_Loop
BWrLN_End:	mov	al,13
		call	WritChar
		mov	al,10
		call	WritChar
		call	PopRegProc
		retf	4
		endp

GetPCStatus	proc	far
		int	011h
		endp

;---- seriell ---
SerIni		proc	far
		arg	Com:Byte,Baud:Word,Pari:Byte,DBits:Byte,sBits:Byte;
		mov	dl,Com
		xor	dh,dh
		mov	al,DBits
		sub	al,5
		mov	ah,sBits
		xor	ah,1
		and	ah,1
		shl	ah,1
		shl	ah,1
		or	al,ah
		mov	ah,Pari
		cmp 	ah,'S'
		jnz	noset
		or	al,16
NoSet:		cmp	ah,'E'
		jnz	noev
		or	al,24
NoEv:		cmp	ah,'O'
		jnz	NoOdd
		or	al,8
NoOdd:		mov	bx,Baud
		xor	ah,ah
		cmp	bx,110
		jz	BaudOk
BaudLoop:	inc	ah
		shr	bx,1
		cmp	bx,75
		jnz	short BaudLoop
BaudOk:		mov	cl,5
		shl	ah,cl
		or	al,ah
		xor	ah,ah
		int	014h
		mov	SerStat,ah
		mov	ModStat,al
		pop	bp
		retf	10
		endp

SerSendChar	proc	far
		arg	Com:Byte,sch:Byte;
		mov	ah,01
		mov	al,sCh
		mov	dl,Com
		xor	dh,dh
		int	014h
		mov	SerStat,al
		pop	bp
		retf	4
		endp

SerEmpfChar	proc	far
		arg	Com:Byte;
		mov	ah,02
		mov	dl,Com
		xor	dh,dh
		int	014h
		mov	SerStat,ah
		xor	ah,ah
		pop	bp
		retf	2
		endp

SerGetStat	proc	far
		arg	Com:Byte;
		mov	ah,03
		mov	dl,Com
		xor	dh,dh
		int	014h
		mov	SerStat,ah
		mov	ModStat,al
		pop	bp
		retf	2
		endp


end
