{======================================================================
 Ntzliche Interrput-Routinen V1.0 15.03.91
 1991 Ralf Amandi

 Das Kopieren und Benutzen fr private Anwendungen ist ohne
 Einschrnkungen erlaubt.

 Kontaktadresse:
 Ralf Amandi
 02403/26689 (Anrufbeantworter)
 Konto: 391 501 00 KrSp Eschweiler
 ======================================================================}

UNIT SAVEINTR;
INTERFACE

TYPE	Interupt_Buffer=ARRAY[0..255] OF Pointer;

{-- Einzelnen Interupt Lesen --}
PROCEDURE GetIntVec(Num:Byte;VAR Adr:Pointer);
{-- Einzelnen Interupt setzen --}
PROCEDURE SetIntVec(Num:Byte;Adr:Pointer);
{-- Interrupt bei Programmende nicht zurcksetzen --}
PROCEDURE FixIntr(Num:Byte);
PROCEDURE DeFixIntr(Num:Byte);{FixIntr wieder Aufheben}

{==== fr meine Assembler-Freude ====}
{liest Interrupt und Speichert im Codesegment der aufrufenden Routine}
{Aufruf: al=Nummer, di=Ofs Buffer   Rckgabe: di+4, cld, sti}
PROCEDURE AsmGetIntr;
{installiert neuen intr-Handler}
{Aufruf: al=Nummer, dx=Ofs Handler  Rckgabe: Ah=025h}
PROCEDURE AsmSetIntr;
{setzt interupt zurck}
{Aufruf: al=Nummer, di=Ofs Buffer   Rckgabe: di+4, sti}
PROCEDURE AsmRestIntr;
{AsmGetIntr+AsmSetIntr}
{Aufruf al=Nummer, di=Ofs Buffer dx=Ofs Handler  Rckgabe di+4,cld,sti}
PROCEDURE AsmInitIntr;

PROCEDURE PushRegProc;
PROCEDURE PushRegFunc;
PROCEDURE PushRegProcBP;
PROCEDURE PushRegFuncBP;
PROCEDURE PopRegProc;
PROCEDURE PopRegFunc;

IMPLEMENTATION
{=== SaveIntr.OBJ definieren ===}
{$L  SaveIntr.OBJ}
PROCEDURE GetIntVec;EXTERNAL;
PROCEDURE SetIntVec;EXTERNAL;
PROCEDURE AsmGetIntr;EXTERNAL;
PROCEDURE AsmSetIntr;EXTERNAL;
PROCEDURE AsmRestIntr;EXTERNAL;
PROCEDURE AsmInitIntr;EXTERNAL;
PROCEDURE PushRegProc;EXTERNAL;
PROCEDURE PushRegFunc;EXTERNAL;
PROCEDURE PushRegProcBP;EXTERNAL;
PROCEDURE PushRegFuncBP;EXTERNAL;
PROCEDURE PopRegProc;EXTERNAL;
PROCEDURE PopRegFunc;EXTERNAL;

{== Pascal-Programm==}

VAR	AltInt  :ARRAY[0..255] OF Pointer;
	RestInt	:ARRAY[0..255] OF Boolean;
	RsSaveIntMask:Byte;
	i	:Byte;
	AltExit	:Pointer;

PROCEDURE Neuex;
BEGIN
 FOR i:=0 TO 255 DO IF RestInt[i] THEN SetIntVec(i,AltInt[i]);
 ExitProc:=AltExit;
END;

PROCEDURE FixIntr(Num:Byte);
BEGIN
 RestInt[Num]:=False;
END;

PROCEDURE DeFixIntr(Num:Byte);{FixIntr wieder Aufheben}
BEGIN
 RestInt[Num]:=True;
END;

BEGIN
 FOR i:=0 TO 255 DO GetIntVec(i,AltInt[i]);
 FillChar(RestInt[0],255,#255);{alle true}
 AltExit:=ExitProc;
 ExitProc:=@Neuex;
END.



Beispiele fr Assembler
z.B. folgender Assembler Kopf
	.Code
EXTRN		AsmGetIntr:proc  ;Al=Num, Di=Ofs Buffer  Unit:SaveIntr
EXTRN		AsmSetIntr:proc  ;Al=Num, Dx=Ofs Handler Unit:SaveIntr
EXTRN		AsmRestIntr:proc ;Al=Num, Di=Ofs Buffer  Unit:SaveIntr
EXTRN		AsmInitIntr:proc ;Al=Num, Dx=Ofs Buffer, Dx=Ofs Handler  Unit:SaveIntr

IntrBuff1	dd	0
IntrBuff2	dd	0

1) AsmGetIntr:
		mov	al,010h		;IntrNummer
		lea	di,IntrBuff1	;Zwischenspeicher
		call	AsmGetIntr	;intr lesen und speichern
		mov	al,021h		;IntrNummer
;		lea	di,IntrBuff2	;Zwischenspeicher -- diese Zeile kann entfallen, da di nun auf IntrBuff2 steht
		call	AsmGetIntr	;intr lesen und speichern
2) AsmSetIntr:
		mov	al,010h		;IntrNummer
		lea	dx,MyInt10	;Intr-Handler
		call	AsmSetIntr	;intr setzen
		mov	al,021h		;IntrNummer
		lea	dx,MyInt21	;Intr-Handler
		call	AsmSetIntr	;intr setzen
3) AsmRestIntr:
		mov	al,010h		;IntrNummer
		lea	di,IntrBuff1	;Zwischenspeicher
		call	AsmRestIntr	;Intr wieder herstellen
		mov	al,021h		;IntrNummer
;		lea	di,IntrBuff2	;Zwischenspeicher -- diese Zeile kann entfallen, da di nun auf IntrBuff2 steht
		call	AsmRestIntr	;Intr wieder herstellen
4) AsmInitIntr
		mov	al,010h		;IntrNummer
		lea	di,IntrBuff1	;Zwischenspeicher
		lea	dx,MyInt10	;Intr-Handler
		call	AsmInitIntr	;Alter Handler -> Buffer, neuen Handler installieren
		mov	al,021h		;IntrNummer
;		lea	di,IntrBuff2	;Zwischenspeicher -- diese Zeile kann entfallen, da di nun auf IntrBuff2 steht
		lea	dx,MyInt21	;Intr-Handler
		call	AsmInitIntr	;Alter Handler -> Buffer, neuen Handler installieren



