{$A+,B-,D-,E+,F-,G-,I+,L-,N-,O-,R-,S-,V-,X-}
{$M 16384,0,0}
{Autor: Martin Mhlhaus}

{Mini-Grafik-Unit fr den Atari-Portfolio, funktioniert auch auf CGA}

UNIT lzgraph;

INTERFACE
USES dos;

TYPE
  ChBM = ARRAY [0..4] OF BYTE;
  ChRange = '$'..'^';
VAR
  regs: registers;
  PutMode: BYTE;
  TextModus: BYTE;

CONST   { Grafik-Zeichensatz, nur Grobuchstaben und einige Zeichen }
  Zeichen: ARRAY [chrange] OF ChBm =  ((121,20,18,20,121),{}
                                       (35,19,8,100,98),  {%}
                                       (57,68,68,68,57),  {}
                                       (61,64,64,64,61),  {}
                                       (0,28,34,65,0),    {(}
                                       (0,65,34,28,0),    {)}
                                       (20,8,62,8,20),    {*}
                                       (8,8,62,8,8),      {+}
                                       (0,0,80,48,0),     {,}
                                       (8,8,8,8,8),       {-}
                                       (0,0,96,96,0),     {.}
                                       (32,16,8,4,2),     {/}
                                       (62,81,73,69,62),  {0}
                                       (0 ,66,127,64,0),  {1}
                                       (66,97,81,73,70),  {2}
                                       (33,65,69,75,49),  {3}
                                       (24,20,18,127,16), {4}
                                       (39,69,69,69,57),  {5}
                                       (60,74,73,73,48),  {6}
                                       (1,1,121,5,3),     {7}
                                       (54,73,73,73,54),  {8}
                                       (6,73,73,41,30),   {9}
                                       (0,0,54,54,0),     {:}
                                       (0,0,86,54,0),     {;}
                                       (0,8,20,34,65),    {<}
                                       (20,20,20,20,20),  {=}
                                       (65,34,20,8,0),    {>}
                                       (2,1,81,9,6),      {?}
                                       (62,65,73,85,14),  {@}
                                       (126,17,17,17,126),{A}
                                       (127,73,73,73,54), {B}
                                       (62,65,65,65,34),  {C}
                                       (127,65,65,34,28), {D}
                                       (127,73,73,73,65), {E}
                                       (127,9,9,9,1),     {F}
                                       (62,65,81,81,114), {G}
                                       (127,8,8,8,127),   {H}
                                       (0,65,127,65,0),   {I}
                                       (32,64,65,63,1),   {J}
                                       (127,8,20,34,65),  {K}
                                       (127,64,64,64,64), {L}
                                       (127,2,12,2,127),  {M}
                                       (127,4,8,16,127),  {N}
                                       (62,65,65,65,62),  {O}
                                       (127,9,9,9,6),     {P}
                                       (62,65,81,33,94),  {Q}
                                       (127,9,25,41,70),  {R}
                                       (38,73,73,73,50),  {S}
                                       (1,1,127,1,1),     {T}
                                       (63,64,64,64,63),  {U}
                                       (31,32,64,32,31),  {V}
                                       (127,32,24,32,127),{W}
                                       (99,20,8,20,99),   {X}
                                       (7,8,120,8,7),     {Y}
                                       (97,81,73,69,67),  {Z}
                                       (0,127,65,65,0),   {[}
                                       (2,4,8,16,32),     {\}
                                       (0,65,65,127,0),   {]}
                                       (4,2,1,2,4));      {^}

CONST
  ChSpace: BYTE = 6;
  GrafikModus: BYTE= $04;
  CopyPut       = $03;
  XORPut        = $83;
  DelPut        = $00;
  GetX: INTEGER = 0;
  GetY: INTEGER = 0;
  NoLastLinePoint: BOOLEAN = TRUE;

PROCEDURE SetDisplay(modus: BYTE);
   { modus: "Textmodus" bzw "Grafikmodus" }
PROCEDURE PutPixel(x, y: INTEGER);
PROCEDURE Line(fromX,fromY,toX,toY:INTEGER);
PROCEDURE LineTo (tox, toY: INTEGER);
PROCEDURE MoveTo (toX, ToY: INTEGER);
PROCEDURE Circle(X,Y,R: WORD);
PROCEDURE PutCh (ch: CHRange);
FUNCTION TextWidth (VAR Str: STRING): INTEGER;
PROCEDURE OutText (Str: STRING);
PROCEDURE OutTextXY (X, Y: INTEGER; Str: STRING);
   { fast alles analog Turbo-Pascal }
   { die Prozeduren PutPixel, Line[To], Circle, PutChar und OutText[XY]
     bercksichtigen den "PutMode":
       - CopyPut: Pixel setzen
       - XorPut:  Pixel ndern
       - DelPut:  Pixel lschen 
      setzen des PutMode z.B.: Putmode := XorPut } 

IMPLEMENTATION

VAR I, J: INTEGER;

PROCEDURE SetDisplay(modus: BYTE);assembler;
  asm
  mov ah,0
  mov al,modus
  int $10
  end;

PROCEDURE Putpixel(x, y: INTEGER); assembler;
  asm
  mov ah,$0c
  mov al,PutMode
  mov bh,0
  mov cx,x
  mov dx,y
  int $10
  end;

PROCEDURE circle(X, Y, R: WORD);
  VAR sinus, cosinus, W, deltaw, limit: REAL;
    a, b: INTEGER;
  BEGIN
  W := 0;
  deltaw := 1/R;
  limit := pi/4+deltaw;
  REPEAT
    sinus := sin(W); cosinus := cos(W);
    a := round(cosinus*(R)); b := round(sinus*(R));
    PutPixel(X+a, Y+b);
    PutPixel(X-a, Y+b);
    PutPixel(X+a, Y-b);
    PutPixel(X-a, Y-b);
    PutPixel(X+b, Y+a);
    PutPixel(X-b, Y+a);
    PutPixel(X+b, Y-a);
    PutPixel(X-b, Y-a);
    W := W + deltaW;
    UNTIL W > limit;
  END;

PROCEDURE MoveTo (toX, ToY: INTEGER);
  BEGIN
  GetX := toX;
  GetY := toY;
  END;

PROCEDURE MoveRel (DX, DY: INTEGER);
  BEGIN
  GetX := GetX + DX;
  GetY := GetY + DY;
  END;

FUNCTION sighn(InNum: INTEGER): INTEGER;
  BEGIN
  IF InNum < 0 THEN sighn := -1 ELSE sighn := 1;
  END;

PROCEDURE Line (fromX,fromY,toX,toY:INTEGER);
  VAR
    UP: BOOLEAN;
    deltaX, deltaY, LastPoint: INTEGER;
    Steigung: REAL;
  BEGIN
  deltaX := toX-fromX;
  deltaY := toY-fromY;
  IF abs(deltaX) > abs (deltaY)
  THEN
    BEGIN
    I := fromX;
    UP := deltaX > 0;
    Steigung := deltaY/deltaX;
    LastPoint := ToX - (sighn(DeltaX) * BYTE(NoLastLinePoint));
    REPEAT
    PutPixel(I,fromY+round((I-fromX)*Steigung));
    IF I = LastPoint THEN exit;
    IF UP THEN inc(I) ELSE dec(I);
    UNTIL FALSE;
    END
  ELSE
    BEGIN
    I := fromY;
    UP := deltaY > 0;
    Steigung := deltaX/deltaY;
    LastPoint := ToY - (sighn(DeltaY) * BYTE(NoLastLinePoint));
    REPEAT
    PutPixel(fromX+round((I-fromY)*Steigung),I);
    IF I = LastPoint THEN exit;
    IF UP THEN inc(I) ELSE dec(I);
    UNTIL FALSE;
    END;
  END;

PROCEDURE LineTo (tox, toY: INTEGER);
  BEGIN
  line (GetX, GetY, toX, toY);
  MoveTo (ToX, ToY);
  END;

PROCEDURE LineRel (DX, DY: INTEGER);
  BEGIN
  LineTo (GetX + DX, GetY + DY);
  END;

PROCEDURE PutCh (ch: CHRange);
  BEGIN
  FOR I := 0 TO 4 DO FOR J := 0 TO 7 DO
    IF (Zeichen[ch,I] AND (1 shl J)) <> 0
    THEN PutPixel (GetX+I,GetY+J-7);
  END;

FUNCTION TextWidth (VAR Str:STRING): INTEGER;
  BEGIN
  TextWidth := ChSpace * (length(Str)-1) + 5;
  END;

PROCEDURE OutText (Str: STRING);
  VAR I: INTEGER;
  BEGIN
  FOR I := 1 TO length(Str) DO
    BEGIN
    IF Str[I] <> #32
    THEN PutCh (Str[I]);
    MoveTo (GetX + ChSpace, GetY)
    END
  END;

PROCEDURE OutTextXY (X, Y: INTEGER; Str: STRING);
  VAR
    OldX, OldY: INTEGER;
  BEGIN
  OldX := GetX;
  OldY := GetY;
  MoveTo (X,Y);
  OutText (Str);
  MoveTo (OldX,OldY)
  END;

BEGIN
  PutMode := CopyPut;
  asm
  mov ah,$0f
  int $10
  mov textmodus,al
  end;
END.