{$A+,B-,D-,E-,F-,G-,I-,L-,N-,O-,R-,S-,V-,X+}
{$M 2000,0,0}
{Autor: Martin Mhlhaus}

USES lzgraph, dosio, dos;

CONST
  Radius = 31;
  UhrX = 40;
  UhrY = 32;
  LaengeKlein = Radius*0.5;
  LaengeGross = Radius*0.7;

VAR h, oh, kh, m, om, km, s, os, ks, hund ,khund : Word;
ch: CHAR;
I: INTEGER;
sinus, cosinus: REAL;

PROCEDURE ZeichneZeiger(Winkel, L: REAL);
  BEGIN
  sinus := sin(Winkel); cosinus := cos(Winkel);
  Line(UhrX+round(sinus*3), UhrY-round(cosinus*3),
       UhrX + round(sinus*L),
       UhrY - round(cosinus*L));
  END;

PROCEDURE Zeiger;
  BEGIN
  ZeichneZeiger(2*pi/12*(oh+om/60), LaengeKlein);
  ZeichneZeiger(2*pi/60*om, LaengeGross);
  END;

PROCEDURE ZeichneSecBall;
  VAR Winkel: REAL;
  Px, Py: INTEGER;
  BEGIN
  Winkel := 2*pi/60*os;
  Px := UhrX + round(sin(Winkel)*(Radius-9));
  Py := UhrY - round(cos(Winkel)*(Radius-9));
  PutPixel(Px+1, Py);
  PutPixel(Px-1, Py);
  PutPixel(Px, Py+1);
  PutPixel(Px, Py-1);
  END;

TYPE LittleStr = STRING[5];

FUNCTION WordStr(InNo:WORD):LittleStr;
  VAR temp: LittleStr;
  BEGIN
  STR(InNo, Temp);
  WordStr := Temp;
  END;

CONST
  days : array [0..6] of String[10] =
    ('SONNTAG','MONTAG','DIENSTAG','MITTWOCH',
     'DONNERSTAG','FREITAG','SAMSTAG');
  status: ARRAY [0..2] OF STRING[22] =
    ('','STOPPUHR L$UFT','STOPPUHR STEHT');
  off = 0; running = 1; stopped = 2;

PROCEDURE WriteStatus(No: BYTE);
  BEGIN
  OutTextXY(89,45,status[No]);
  END;

VAR
  year, month, day, dow : Word;
  sw, oldsw : BYTE;
  la, lb, ha, hb: SHORTINT;

BEGIN
grafikmodus := $04;
SetDisplay(GrafikModus);
PutMode := copyPut;
I := 0;
REPEAT
  sinus := sin(I*pi/180); cosinus := cos(I*pi/180);
  la := round(cosinus*(Radius-1)); lb := round(sinus*(Radius-1));
  ha := round(cosinus*(Radius-7)); hb := round(sinus*(Radius-7));
  Line(UhrX+la, UhrY+lb, UhrX+ha, UhrY+hb);
  Line(UhrX-la, UhrY-lb, UhrX-ha, UhrY-hb);
  Line(UhrX-lb, UhrY+la, UhrX-hb, UhrY+ha);
  Line(UhrX+lb, UhrY-la, UhrX+hb, UhrY-ha);
  inc(I,30);
  UNTIL I = 90;
NoLastLinePoint := FALSE;
circle (UhrX,UhrY,Radius);
PutPixel(UhrX, UhrY);
PutPixel(UhrX+1, UhrY);
PutPixel(UhrX-1, UhrY);
PutPixel(UhrX, UhrY+1);
PutPixel(UhrX, UhrY-1);
OutTextXY(82,22,'DIGITALUHR - NEIN DANKE');
line(80,24,220,24);
GetDate(year,month,day,dow);
Status[0] := days[dow]+', '+wordstr(day)+#46+
                wordstr(month)+#46+wordstr(Year);
WriteStatus(0);
sw := 0;
om := 60; oh := 0; os := 60;
kh := 0; km := 0; ks := 0;
PutMode := XorPut;
ZeichneSecBall;
I := 0; ch := ' ';
REPEAT
  IF sw <> stopped THEN BEGIN
    GetTime(h,m,s,hund);
    IF sw = running THEN BEGIN
      inc(h, kh); inc(m, km); inc(s, ks); inc(hund, khund);
      IF hund > 99 THEN BEGIN dec(hund,100); inc(s, 1) END;
      IF s > 59 THEN BEGIN dec(s,60); inc(m, 1) END;
      IF m > 59 THEN BEGIN dec(m,60); inc(h, 1) END;
      I := 0;
      END;
    h := h mod 12;
    END;
  IF (os <> s) THEN BEGIN
    ZeichneSecBall;
    os := s;
    IF (om <> m) OR (oh <> h) THEN BEGIN
      inc(I);
      PutMode := DelPut;
      Zeiger;
      PutMode := CopyPut;
      om := m; oh := h;
      Zeiger;
      PutMode := xorput;
      END;
    ZeichneSecBall;
    END;
  IF KeyPressed THEN ch := UpCase(readkey);
  IF ch = ^M THEN BEGIN
    oldsw := sw;
    inc(sw); IF sw > stopped THEN sw := off;
    IF sw = running THEN BEGIN
      kh := 11-oh; km := 59-om; ks := 59-os; khund := 100-hund END;
    WriteStatus(oldsw);
    WriteStatus(sw);
    ch := ' ';
    END;
  UNTIL (ch = #27) OR (I>4);
setdisplay(TextModus);
writeln('UHR.EXE beendet'#13#10'(C)1991 Martin Mhlhaus');
END.