/* iostream.h -- basic stream I/O declarations

    Copyright (c) 1990 by Borland International    
	All rights reserved.

    There are some inline functions here which generate a LOT of code
    (as much as 300 bytes), but are available inline because AT&T did
    it that way.  We have also made them true functions in the library
    and conditionally deleted the inline code from this header.
    
    If you really want these big functions to be inline, #define the
    macro name _BIG_INLINE_ before including this header.

    Programs will compile and link correctly even if some modules are
    compiled with _BIG_INLINE_ and some are not.
*/

#ifndef __IOSTREAM_H
#define __IOSTREAM_H

#include <mem.h>	// to get memcpy and NULL

#if __STDC__
#define _Cdecl
#else
#define _Cdecl	cdecl
#endif

// Definition of EOF must match the one in <stdio.h>
#define EOF (-1)

// extract a char from int i, ensuring that zapeof(EOF) != EOF
#define	zapeof(i) ((unsigned char)(i))

typedef long streampos;
typedef long streamoff;

class streambuf;
class ostream;


class ios {
public:
	// stream status bits
	enum io_state	{
		goodbit	 = 0x00,	// no bit set: all is ok
		eofbit	 = 0x01,	// at end of file
		failbit	 = 0x02,	// last I/O operation failed
		badbit	 = 0x04,	// invalid operation attempted
		hardfail = 0x80		// unrecoverable error
		};

	// stream operation mode
	enum open_mode	{
		in	 = 0x01,	    // open for reading
		out	 = 0x02,	    // open for writing
		ate	 = 0x04,	    // seek to eof upon original open
		app	 = 0x08,	    // append mode: all additions at eof
		trunc	 = 0x10,	// truncate file if already exists
		nocreate = 0x20,	// open fails if file doesn't exist
		noreplace= 0x40,	// open fails if file already exists
		binary	 = 0x80		// binary (not text) file
		};

	// stream seek direction
	enum seek_dir { beg=0, cur=1, end=2 };

	// formatting flags
	enum	{
		skipws	  = 0x0001,	// skip whitespace on input
		left	  = 0x0002,	// left-adjust output
		right	  = 0x0004,	// right-adjust output
		internal  = 0x0008,	// padding after sign or base indicator
		dec	  = 0x0010,	    // decimal conversion
		oct	  = 0x0020,	    // octal conversion
		hex	  = 0x0040,	    // hexidecimal conversion
		showbase  = 0x0080,	// use base indicator on output
		showpoint = 0x0100,	// force decimal point (floating output)
		uppercase = 0x0200,	// upper-case hex output
		showpos	  = 0x0400,	// add '+' to positive integers
		scientific= 0x0800,	// use 1.2345E2 floating notation
		fixed	  = 0x1000,	// use 123.45 floating notation
		unitbuf	  = 0x2000,	// flush all streams after insertion
		stdio	  = 0x4000	// flush stdout, stderr after insertion
		};

	// constants for second parameter of seft()
static	const long basefield;		// dec | oct | hex
static	const long adjustfield;		// left | right | internal
static	const long floatfield;		// scientific | fixed

	// constructor, destructor
		_Cdecl ios(streambuf*);
virtual	_Cdecl ~ios();

	// for reading/setting/clearing format flags
	long	_Cdecl flags();
	long	_Cdecl flags(long);
	long	_Cdecl setf(long _setbits, long _field);
	long	_Cdecl setf(long);
	long	_Cdecl unsetf(long);

	// reading/setting field width
	int	    _Cdecl width();
	int	    _Cdecl width(int);

	// reading/setting padding character
	char	_Cdecl fill();
	char	_Cdecl fill(char);

	// reading/setting digits of floating precision
	int	    _Cdecl precision(int);
	int	    _Cdecl precision();

	// reading/setting ostream tied to this stream
	ostream* _Cdecl tie(ostream*);
	ostream* _Cdecl tie();

	// find out about current stream state
	int	    _Cdecl rdstate();		// return the stream state
	int	    _Cdecl eof();			// non-zero on end of file
	int	    _Cdecl fail();			// non-zero if an operation failed
	int	    _Cdecl bad();			// non-zero if error occurred
	int	    _Cdecl good();			// non-zero if no state bits set
	void	_Cdecl clear(int = 0);	// set the stream state
		    _Cdecl operator void* ();	// zero if state failed
	int	    _Cdecl operator! ();	// non-zero if state failed

	streambuf* _Cdecl rdbuf();		// get the assigned streambuf

	// for declaring additional flag bits and user words
static long	_Cdecl bitalloc();	// acquire a new flag bit, value returned
static int	_Cdecl xalloc();	// acquire a new user word, index returned
	long  & _Cdecl iword(int);	// return the nth user word as an int
	void* & _Cdecl pword(int);	// return the nth user word as a pointer

static void	_Cdecl sync_with_stdio();

	// obsolete, for streams 1.2 compatibility
	int	    _Cdecl skip(int);

protected:
	// additional state flags for ispecial and ospecial
	enum { skipping = 0x100, tied = 0x200 };

	streambuf* bp;		    // the associated streambuf
	ostream* x_tie;		    // the tied ostream, if any
	int	    state;		    // status bits
	int	    ispecial;	    // istream status bits	***
	int	    ospecial;	    // ostream status bits	***
	long 	x_flags;	    // formatting flag bits
	int	    x_precision;	// floating-point precision on output
	int 	x_width;	    // field width on output
	int	    x_fill;		    // padding character on output
	int	    isfx_special;	// unused		***
	int	    osfx_special;	// unused		***
	int	    delbuf;		    // unused		***
	int	    assign_private;	// unused		***
/*
 * The data members marked with *** above are not documented in the AT&T
 * release of streams, so we cannot guarantee compatibility with any
 * other streams release in the use or values of these data members.
 * If you can document any expected behavior of these data members, we
 * will try to adjust our implementation accordingly.
 */

		    _Cdecl ios();		// null constructor, does not initialize
            
	void	_Cdecl init(streambuf*);	// the actual initialization

	void	_Cdecl setstate(int);	    // set all status bits

static	void _Cdecl (*stdioflush)();

private:
	// for extra flag bits and user words
static	long	nextbit;
static	int	usercount;
	union ios_user_union *userwords;
	int	    nwords;
	void	_Cdecl usersize(int);

	// these declarations prevent automatic copying of an ios
		    _Cdecl ios(ios&);		    // declared but not defined
	void	_Cdecl operator= (ios&);	// declared but not defined

};
inline streambuf* _Cdecl ios::rdbuf() { return bp; }
inline ostream* _Cdecl ios::tie() { return x_tie; }    
inline char	    _Cdecl ios::fill() { return x_fill; }
inline int	    _Cdecl ios::precision() { return x_precision; }
inline int	    _Cdecl ios::rdstate() { return state; }
inline int	    _Cdecl ios::eof() { return state & eofbit; }
inline int	    _Cdecl ios::fail() { return state & (failbit | badbit | hardfail); }
inline int	    _Cdecl ios::bad() { return state & (badbit | hardfail); }
inline int	    _Cdecl ios::good() { return state == 0; }
inline long	    _Cdecl ios::flags() { return x_flags; }
inline int	    _Cdecl ios::width() { return x_width; }
inline int	    _Cdecl ios::width(int _w) { int _i = x_width; x_width = _w; return _i; }
inline char	    _Cdecl ios::fill(char _c) { char _x = x_fill; x_fill = _c; return _x; }
inline int	    _Cdecl ios::precision(int _p) {
			            int _x = x_precision; x_precision = _p; return _x;
		                }
inline		    _Cdecl ios::operator void* () { return fail() ? 0 : this; }
inline int	    _Cdecl ios::operator! () { return fail(); }


class streambuf {
public:
	// constructors and destructors
	    _Cdecl streambuf();		        // make empty streambuf
	    _Cdecl streambuf(char*, int);	// make streambuf with given char array
virtual	_Cdecl ~streambuf();

	// use the provided char array for the buffer if possible
virtual streambuf* _Cdecl setbuf(  signed char*, int);
	// WARNING:  this function is not virtual; do not override
   	streambuf*  _Cdecl setbuf(unsigned char*, int);

	// obsolete, for streams 1.2 compatibility
	streambuf*  _Cdecl setbuf(char*, int, int);

	// getting (extracting) characters
	int	    _Cdecl sgetc();		    // peek at next char
	int	    _Cdecl snextc();		// advance to and return next char
	int	    _Cdecl sbumpc();		 GGETMEMj(  _TEXTCODE_DATADATA_BSSBSSDGROUPј ( ' H   H   U
 _malloc   
__graphgetmem      Uv  Y]˟ V}  t               GOTOXY(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (P  H   H   U
 __video 
 
__VideoInt }  _gotoxy   QT   ULLFF  FFF   FF: r": wF:  r: w
Vv   ]# JV;5,&  t    GPTEXT(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (  H   H   U __VALIDATEXY 
 
__SCREENIO G	 __VPTR [  _puttextQ    _gettext      UVWvvvv
  u31F+F@vvvvV  RPW  FF;v
~ _^]UVWF+F@vvV  RPvvW  FF;v
~ _^]é uViV;V5VV  t  
 GREGISTR(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (   H   H   U _registerfarbgidriver  _registerfarbgifont e  _registerbgidriver     _registerbgifont  $   Uv    YY]Uv    YY]ý	 VV  t               	 HEAPLENs(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (  3 H 
 H   U 	__heaplen        X  t 	 INSLINE^(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (<  H   H   U
 __video  	__wherexy  __SCROLL Ԑ  _insline     _delline  @   P  P  P P PP  ðP  P  P P PP  ø/ 9V2.&V"VVo  t           KEEPQ(  _TEXTCODE_DATADATA_BSSBSSDGROUPј ( ! H   H   U 
__restorezero Ր  _keep   Z   U  VF1!] V  t              LABST(  _TEXTCODE_DATADATA_BSSBSSDGROUPј ((  H   H   U  _labs   ],   U~ |~ sVF؃ VF];  t  
 LOADPROG(  _TEXTCODE_DATADATA_BSSBSSDGROUPј ( j H   H   U _environ 	 _errno  	__exitbuf  _free f __SEARCHPATH  __DOSENV Ԍ __DOSCMD   
__LoadProg   ~   UVvvF
 P  FVu    vv
  FVu   ߋFFu
   VFvvvvFP  FVu   vv  YY  vvvvvvVvv  YYvv  YY^]y7 VVĐV}oVUQB4V#V  t             LOCALE(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (B  H? И H   U
 _strcmp k  
_setlocale   9  _localeconv<  F   UFFuڸ; (^&? t= PvS  t33VF]Ìڸ  B ?%VUC   0   2   3   4   5   6   7   8   9   :   .          C C Y3 $    t            	 LSEARCHn(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (  H   H   U
 _movmem s
  _lfind  e  _lsearchg     UV^
&7vvvvVu8FFN݃~ t^
&vvvvv  

F  F  VF^] Uvvv
vvvvv Pw]Uvvv
vvvvv3PT]h KV9  t 	 MEMICMPh(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (C  H   H   U _toupper   _memicmp   G   UV.^& P  YP^& P  YZ+ЋtFFFNw3^]É	 VVw  t        MKTEMP(  _TEXTCODE_DATADATA_BSSBSSDGROUPј ( ; H  H   U
 _strcmp k
 _strlen l
 _access   _mktemp   m   UVvv  YY= } FVփVF  Pvv  t ^&G.FA  ^F&FA x^F&GFA ^^F&GFA D^F&GFA *^F&GPvv  =uVF4F~Z~F~Z~F~Z~F~Z~F~Zf33^]Ï V9V/V   XXXXXX C  t    
 MOVETEXT(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (  H   H   U __VALIDATEXY 
 
__SCREENIO G	 __VPTR [  	_movetext   {   UVW~vWvv
  t$vvF+FVRF
+ǋVR  u3\~F
FF ;~}F
F~Fv)v+ǋVR  RPvV  RPF+F@P  vFF;u͸ _^] VVxV:VV,  t      
 MULTBYTE(  _TEXTCODE_DATADATA_BSSBSSDGROUPј ( P H   H   U  _mbtowc  P  	_mbstowcso  
  _mblen     	_wcstombs  ܐ  _wctombR     UFFu3^&? u ]UFF
u3"FFt^&^&^&? uݸ ]UFFu3^F& ]UV3^&^&FFF;vs	^&? u;vs^& ^]UV3^&^&FFF;vs	^&? u;vs^& ^]ý  t           PEEKQ(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (  H   H   U
  _peekb    _peek   Z    UF^&]UF^&]j  t               PERROR(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (S  H{ H   U	 _errno  _fprintf 	 	__streams  _sys_errlist   , 	_sys_nerr    _perror   aW   U  ; }|  ㋇   VFFe^vvvvsP( P  ]Õ- JVFA.!                        &  8  U  i  x                                                                 2  @  Q  $ Error 0 Invalid function number No such file or directory Path not found Too many open files Permission denied Bad file number Memory arena trashed Not enough memory Invalid memory block address Invalid environment Invalid format Invalid access code Invalid data No such device Attempted to remove current directory Not same device No more files Invalid argument Arg list too big Exec format error Cross-device link Math argument Result too large File already exists Unknown error %s: %s
 ~ ̌̈̄XTPLHD@<40,($  g  t               POKEG(  _TEXTCODE_DATADATA_BSSBSSDGROUPј ("  H   H   U
  _pokeb  ې  _poke   P&   UF^F&]UF^F&]÷  t         PRINTF(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (  H   H   U
 
__VPRINTER % 	__streams 
 __FPUTN   _printf   h   U  P PvvFP  ] V	V]  t               PUTC:(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (" H  H 
 U
 _fflush |	 _write ی
 _memcpy y 	__streams 
 __write z  __fputc   z  	_fputchart %
  _fputc    __FPUTN &  U^&H&vSFP ]UVF  ^&?}M&@&&G&w&G  &F&G t#>  
t>  
uvv  YYt  ^&G u&G u^&O ^&O & tc&? tvS  YYt^&G&&G&w&G  &F&G t >  
t>  
uvv  YYth]>  
u%^&G@ u P  P&GP  = u P  P^&GP  = t^&G u	&O 	   ^]UVv PV^]UVWv^&G t-!vv^
F
&Pi=u3ZNuN^&G@ u & u &9ws4&? tvS  YYtVvv
^&GP  ;s ^&|$&? u&+G&vv  YYtqVvv
^&w&w  
^&&&w Vvv
^&GP  ;s* ^& t]R^&@&}&&GPS&_[&G^
F
&&´ vv^
F
&P=uNuVvv
^&GP  ;s_^]
 &i VV_VAVVV}mNVA1V'VVmVaZF&   
L  t             PUTCH(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (  H   H   U
 __CPUTN 
  _putch   ٠   UFP P33PR  ]Ð Vq  t             PUTS*(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (H  H   H   U	 _fputc 
 _strlen l 	__streams 
 __FPUTN   _puts   3L   UVvv  YYvvP P  ;t P
 P  =
 t
 ^]& 3V+VV[  t    PUTW&(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (  H   H   U
 __fputc   _putw   /   UV^&@&}&G&w&GV&´ vvFP  =tB^&@&}&G&w&GV&´ vvFP  =tF^]þ	 tV7V  t         RANDQ(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (7  H  H   U N_LXMUL@ 
  _srand     _rand  I;   UF     ]Ë   Z5N        %4( 0-) V      U  t                REWIND(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (%  H   H   U	 _fseek   _rewind   r)   U3P3PRvv  
u	^&g]Ɯ Vs  t              SCANF	(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (#  H   H   U 	__Nungetc ͌ __Nfgetc L 	__streams  	__scanner 
  _scanf   '   UFPvv  P  P  P  ]â VVV  t      SCREEN(  _TEXTCODE_DATADATA_BSSBSSDGROUPј ( H   H   U	 __VRAM q _directvideo h
 __video  	__wherexy 
 
__VideoInt }  __VALIDATEXYp &  
__SCREENIO3 
  ULLFȠ  P3[F   *ЈVf] U^&^&;t
   ^&: rƲ ^&] U
VW  FFF;
 u 3Ftvv
cFF;
 u 3tavvAFStFPFPc   
^&7F~ tFPFP;Ɗܹ  	  
^
&7F
FNuV   _^]
 U	  u>   tvv
vvv  vv
vvv ]
 U  Ƞ  9N
w$9NwF
;F9Vw9Vw
F;F 3] F {tVVA7)V	VVĥĂuVZNV 
ۊ  t           SCROLL(  _TEXTCODE_DATADATA_BSSBSSDGROUPј ( H   H   U _directvideo h
 __video  _puttext  _gettext  	_movetext 
 
__VideoInt }  __SCROLL&    UVv^& ^&FF;v~^] U 	  t>>   u4~t+FF
FF~t F
 PF PF PF PF
 @PF P  `PF PF PF PF P  `PF PF P;`PF PF PF PF P   F
 @PF PF HPF PF
 PF P  `PF
 PF PF
 PF P  `PF PF P`PF
 PF PF
 PF P  > fFn
NvV  ] _, VypV7VVVVV;.I  t       SETBUF(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (+  H   H   U _setvbuf   _setbuf   r/   U PFF
t3 Pv
vvv  ]x $V`  t     	 SETMODE_  h _TEXTCODE (` Ӗ _DATADATA H  
 _BSSBSS* H   DGROUP U 	__IOERROR __openfd 3  _setmode   d   UVWv~ |~}^ヿ  u 3% ;u%= t ^㋷  ^%?ǉ  %  P  _^] <LZ/  t   	 SETUPIOG  h _TEXTCODE (m Ɩ _DATADATA H  
 _BSSBSS* H   _INIT_INITDATA H 	 DGROUP 
S _setvbuf 	__streams _isatty %  	__setupio   q    P  Yu&  P t 3P33PR  P   P  Yu&  P t 3P33PR P  Â= -17<EOcg
        P TD  t 	 SETVBUFQ(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (" H  H   U	 _fseek  	__exitbuf  _free f
 _malloc  	__xfflush  	__streams   _setvbuf     UVW~v^&G;uv >  u~ u  >   u
~  u   ^&? t P33PRvS  
^&G t
&w
&w  YY^&g&G  FV&W&G
&W&GtWvS    FF
uV  YFV
t^&O ?^F
V&W&G&W&G
&wu&O 3_^]q4 VĻVĹViVMG?71)       V  t 	 SIGDATAs(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (  3 H   H 	 U ___SignalPtr     t        SIGNAL(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (G H  H  U	 _errno  _setvect  _getvect 	 __exit  ___SignalPtr 
  _raise| k  _signal ՠ  PSQRVWU  ݋^&?bt  3 = t)t=u P  Y   F P
 P Pփ]_^ZY[XPSQRVWU  ݋ = t)t=u P  Y   F P P Pփ]_^ZY[XPSQRVWU  ݋ = t)t=u P  Y   F P P Pփ]_^ZY[XPSQRVWU  ݋ = t)t=u P  Y   F P~ P Pփ]_^ZY[XPSQRVWU  ݡ = tt=u P  Y    PY]_^ZY[XUV3  ;Fu	F|^]ULLVW~ u   WY=u    ㋇ FF u
  PDP# hu  P P3P    P P Eu0  u? P  Y     P  P P    u  P] P P  F_^]UVWvY=u R㋇ = tAu%F= t= t P  Y#" P  YǇ     PvYY3_^]ڜ VVƚnVfTbTWPVHTDTA=9V-TTVT
TTTŽTŻŲŎojVSN$VVĻȴĊVng=8V!
                    V  t    SLEEP(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (c И H   H   U _gettime 
  _sleep   g   UVWFP  YY~ZvZ F F FP  YYF ;tFNuFP  YYF ;|_^]c
 PV3VV5  t        SPAWNL(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (Q  H   H   U	 _errno 
 
__LoadProg 	 __exec 
 __spawn |  _spawnl   fU   UFt= t 53P3PRF
Pvv  P   3P3PRF
Pvv     ][ HBV(V$V  t           	 SPAWNLEV(  _TEXTCODE_DATADATA_BSSBSSDGROUPј ({  H   H   U	 _errno 
 
__LoadProg 	 __exec 
 __spawn |  _spawnle      UF
FV^F&&GuFt= t&A3P^&w&7F
Pvv  P  &3P^&w&7F
Pvv     ]T pjVJVFV  t               	 SPAWNLPK(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (W ܘ H   H   U	 _errno 
 
__LoadProg 	 __exec 
 __spawn |  _spawnlp   [   UFt= t#; P33PRF
Pvv  P  # P33PRF
Pvv     ]ڜ NHV+V'Vw  t   
 SPAWNLPE(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (}  H   H   U	 _errno 
 
__LoadProg 	 __exec 
 __spawn |  	_spawnlpe      UF
FV^F&&GuFt= t'C P^&w&7F
Pvv  P  ' P^&w&7F
Pvv     ]Ü rlVKVGV  t            SPAWNV(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (S  H   H   U	 _errno 
 
__LoadProg 	 __exec 
 __spawn |  _spawnv   \W   UFt= t!73P3PRvv
vv  P  !3P3PRvv
vv     ]ܜ JDV)V%V  t         	 SPAWNVEL(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (W ܘ H   H   U	 _errno 
 
__LoadProg 	 __exec 
 __spawn |  _spawnve   [   UFt= t#;3Pvvvv
vv  P  #3Pvvvv
vv     ] NHV+V'Vw  t   	 SPAWNVPA(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (Y ژ H   H   U	 _errno 
 
__LoadProg 	 __exec 
 __spawn |  _spawnvp   ]   UFt= t$= P33PRvv
vv  P  $ P33PRvv
vv     ][ PJV,V(Vq  t 
 SPAWNVPE(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (Y ژ H   H   U	 _errno 
 
__LoadProg 	 __exec 
 __spawn |  	_spawnvpe   ]   UFt= t$= Pvvvv
vv  P  $ Pvvvv
vv     ] PJV,V(Vq  t               	 SPRINTFJ(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (  H   H   U
 _memcpy y
 
__VPRINTER %  _sprintf>    	_vsprintf`     UVvVvv
^&w&7  
^&7S&G[&& ^]
 U^&   PFPv
vFP  ]U^&   PFPv
vv  ]Ã }VkT\VITV  t            SSCANF(  _TEXTCODE_DATADATA_BSSBSSDGROUPј (z  H   H   U 	__scanner   _vsscanfV    _sscanf3  J~   UV^&G&7&&
u´ ^]U^&]UFPv
vFP( P  P  ]Uvvv
vFP( P  P  ] sVoTkTOVKTGT  t                STIME(  _TEXTCODE_DATA^&^&G^&_VF]U,  ^
&G^&^ʐ  ^FNF^萛^
& v^ʛ&GNfv^FP(  FP    YY^ʐ    6 ^FP@YY6 ^vv(  FVVF^&^&^&G^&_VF]U  ^
&G^ސ    ~n~쐛^
&^ސ    nnɛ6 ^ސ^
&^֐    nnɛ6 ^֐vv(  FVVF^&^&^&G^&_VF]U  ^
&^ސ    ~n~쐛^
&G^ސ    nnɛ6 ^ސ^
&G^֐    nnɛ6 ^֐vv(